<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Haleon Order #{{ $order->id }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #000;
        }
        .header {
            background-color: #30ea03;
            padding: 15px;
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #000;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-row {
            margin-bottom: 8px;
        }
        .label {
            font-weight: bold;
            display: inline-block;
            width: 120px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        thead {
            background-color: #d0d3d4;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            font-weight: bold;
            text-align: center;
        }
        td.center {
            text-align: center;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            font-style: italic;
        }
        .brand-section {
            margin-top: 20px;
            page-break-inside: avoid;
        }
        .brand-header {
            background-color: #f0f0f0;
            padding: 8px;
            font-weight: bold;
            margin-top: 15px;
            border-left: 4px solid #30ea03;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Haleon Product Order</h1>
    </div>

    <div class="info-section">
        <div class="info-row">
            <span class="label">Order ID:</span>
            <span>#{{ $order->id }}</span>
        </div>
        <div class="info-row">
            <span class="label">Pharmacy:</span>
            <span>{{ $order->pharmacy_name ?? 'N/A' }}</span>
        </div>
        <div class="info-row">
            <span class="label">Email:</span>
            <span>{{ $order->email }}</span>
        </div>
        <div class="info-row">
            <span class="label">Date:</span>
            <span>{{ $order->created_at->format('Y-m-d H:i:s') }}</span>
        </div>
        <div class="info-row">
            <span class="label">Total Items:</span>
            <span>{{ $order->total_items }}</span>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="35%">Product</th>
                <th width="15%">Size</th>
                <th width="25%">Barcode</th>
                <th width="15%">Brand</th>
                <th width="10%">Qty</th>
            </tr>
        </thead>
        <tbody>
            @foreach($items as $item)
                @php
                    $details = $item->getProductDetails();
                @endphp
                <tr>
                    <td>{{ $details['name'] }}</td>
                    <td class="center">{{ $details['size'] }}</td>
                    <td class="center">{{ $details['barcode'] }}</td>
                    <td>{{ $details['brand_name'] }}</td>
                    <td class="center">{{ $item->quantity }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    @if($order->notes)
        <div style="margin-top: 20px;">
            <strong>Notes:</strong><br>
            {{ $order->notes }}
        </div>
    @endif

    <div class="footer">
        Generated by Haleon Orders API on {{ now()->format('Y-m-d H:i:s') }}
    </div>
</body>
</html>
