<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Processing Failed</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: #dc3545;
            padding: 20px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .header h1 {
            color: white;
            margin: 0;
            font-size: 24px;
        }
        .content {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 0 0 8px 8px;
        }
        .error-box {
            background: #fff3cd;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 15px 0;
            border-radius: 4px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>⚠️ Order Processing Failed</h1>
    </div>

    <div class="content">
        <p>We're sorry, but there was an issue processing your Haleon product order.</p>

        <div class="error-box">
            <strong>Order ID:</strong> #{{ $order->id }}<br>
            <strong>Date:</strong> {{ $order->created_at->format('F d, Y \a\t h:i A') }}<br><br>
            <strong>Error Reason:</strong><br>
            {{ $reason }}
        </div>

        <p>
            Please try submitting your order again. If the problem persists, contact our support team
            with the order ID mentioned above.
        </p>

        <p>We apologize for any inconvenience this may have caused.</p>
    </div>

    <div class="footer">
        <p>Haleon Orders System</p>
        <p style="font-size: 10px;">This is an automated email. Please do not reply to this message.</p>
    </div>
</body>
</html>
