<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Add new columns
            $table->foreignId('company_id')->nullable()->after('id')->constrained('companies')->onDelete('cascade');
            $table->foreignId('rep_id')->nullable()->after('company_id')->constrained('users')->onDelete('set null');
            $table->foreignId('pharmacy_id')->nullable()->after('rep_id')->constrained('pharmacies')->onDelete('set null');
            $table->foreignId('wholesaler_id')->nullable()->after('pharmacy_id')->constrained('wholesalers')->onDelete('set null');
            $table->string('wholesaler_account_number')->nullable()->after('wholesaler_id');
            $table->string('order_number')->unique()->after('wholesaler_account_number');
            $table->date('delivery_date')->nullable()->after('order_number');
            $table->decimal('total_amount', 10, 2)->default(0)->after('total_items');

            // Remove pharmacy_name column (replaced by pharmacy_id FK)
            // Note: In production, you may want to migrate data before dropping
            $table->dropColumn('pharmacy_name');

            // Indexes
            $table->index('company_id');
            $table->index('rep_id');
            $table->index('pharmacy_id');
            $table->index('wholesaler_id');
            $table->index('order_number');
            $table->index(['company_id', 'status']);
            $table->index(['rep_id', 'created_at']);
            $table->index(['pharmacy_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Drop foreign keys first
            $table->dropForeign(['company_id']);
            $table->dropForeign(['rep_id']);
            $table->dropForeign(['pharmacy_id']);
            $table->dropForeign(['wholesaler_id']);

            // Drop indexes
            $table->dropIndex(['orders_company_id_index']);
            $table->dropIndex(['orders_rep_id_index']);
            $table->dropIndex(['orders_pharmacy_id_index']);
            $table->dropIndex(['orders_wholesaler_id_index']);
            $table->dropIndex(['orders_order_number_index']);
            $table->dropIndex(['orders_company_id_status_index']);
            $table->dropIndex(['orders_rep_id_created_at_index']);
            $table->dropIndex(['orders_pharmacy_id_created_at_index']);

            // Drop columns
            $table->dropColumn([
                'company_id',
                'rep_id',
                'pharmacy_id',
                'wholesaler_id',
                'wholesaler_account_number',
                'order_number',
                'delivery_date',
                'total_amount'
            ]);

            // Restore pharmacy_name column
            $table->string('pharmacy_name')->nullable()->after('id');
        });
    }
};
