<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PharmacyWholesalerAccountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'wholesaler_id' => $this->id,
            'wholesaler_name' => $this->wholesaler_name,
            'account_number' => $this->pivot->account_number ?? null,
            'is_primary' => $this->pivot->is_primary ?? false,
            'status' => $this->pivot->status ?? 'active',
            'email' => $this->email,
            'phone' => $this->phone,
        ];
    }
}
