<?php

namespace App\Jobs;

use App\Services\PDFService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class CleanupExpiredPDFsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Execute the job.
     */
    public function handle(PDFService $pdfService): void
    {
        Log::info("Starting cleanup of expired PDFs");

        $count = $pdfService->cleanupExpiredPDFs();

        Log::info("Cleanup completed", ['deleted_count' => $count]);
    }
}
